/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.ui.AbstractUIAction;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class UIInfo
implements Serializable,
Cloneable {
    private LocalizableText name;
    private LocalizableText caption;
    private String imageName;
    private String tinyImageName;
    private String imageURL;
    private String tinyImageURL;
    private LocalizableText objectTypeName;
    private ArrayList actions;
    private static final long serialVersionUID = -5769030975653458033L;
    private static final String DEFAULT_NAME = "no name";
    private static final String DEFAULT_CAPTION = "no caption";
    private static final String DEFAULT_IMAGE_NAME = "com/ibm/hwmca/fw/images/default.gif";
    private static final String IMAGE_URI = "/res/com/ibm/hwmca/fw/images";
    private static final UIInfo DEFAULT_UIINFO = new UIInfo(new LocalizableText("no name"), new LocalizableText("no caption"));
    public static final String URI = "/res";
    public static final String DEFAULT_IMAGE_URL = "/res/com/ibm/hwmca/fw/images/default.gif";

    public UIInfo(LocalizableText name, LocalizableText caption) throws IllegalArgumentException {
        this(name, caption, null, null, null);
    }

    public UIInfo(LocalizableText name, LocalizableText caption, String imageName) throws IllegalArgumentException {
        this(name, caption, imageName, null, null);
    }

    public UIInfo(LocalizableText name, LocalizableText caption, String imageName, String tinyImageName, LocalizableText objectTypeName) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name passed to UIInfo constructor is null");
        }
        if (caption == null) {
            throw new IllegalArgumentException("caption passed to UIInfo constructor is null");
        }
        this.setName(name);
        this.setCaption(caption);
        if (imageName == null) {
            this.setImageName(DEFAULT_IMAGE_NAME);
        } else {
            this.setImageName(imageName);
        }
        this.setTinyImageName(tinyImageName);
        this.setObjectTypeName(objectTypeName);
    }

    public static UIInfo getDefaultUIInfo() {
        return DEFAULT_UIINFO;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getName(Locale locale) {
        return this.name.toString(locale);
    }

    public String getNameAsHtml() {
        return UIInfo.getNameAsHtml(this.getName());
    }

    public String getNameAsHtml(Locale locale) {
        return UIInfo.getNameAsHtml(this.getName(locale));
    }

    public static String getNameAsHtml(String name) {
        return name.toString().replaceAll("\n", "<br>");
    }

    public LocalizableText getUnlocalizedName() {
        return this.name;
    }

    public LocalizableText getUnlocalizedCaption() {
        return this.caption;
    }

    public String getTitle() {
        return this.getTitle(Locale.getDefault());
    }

    public String getTitle(Locale locale) {
        return this.getName(locale).replace('\n', ' ');
    }

    public void setName(LocalizableText name) {
        this.name = name;
    }

    public String getCaption() {
        return this.caption.toString();
    }

    public String getCaption(Locale locale) {
        return this.caption.toString(locale);
    }

    public void setCaption(LocalizableText caption) {
        this.caption = caption;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageURL() {
        return UIInfo.getImageURL(this.imageName);
    }

    public static String getDefaultImageURL() {
        return DEFAULT_IMAGE_URL;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
    }

    public String getTinyImageName() {
        return this.tinyImageName;
    }

    public String getTinyImageURL() {
        if (this.tinyImageURL == null) {
            return null;
        }
        return UIInfo.getImageURL(this.tinyImageURL);
    }

    public static String getImageURL(String name) {
        if (name == null) {
            return DEFAULT_IMAGE_URL;
        }
        if (name.startsWith("/")) {
            return URI + name;
        }
        return "/res/" + name;
    }

    public void setTinyImageName(String imageName) {
        this.tinyImageName = imageName;
    }

    public void setTinyImageURL(String imageURL) {
        this.tinyImageURL = imageURL;
    }

    public LocalizableText getObjectTypeName() {
        return this.objectTypeName;
    }

    public void setObjectTypeName(LocalizableText objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    public void addUIAction(AbstractUIAction action) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        this.actions.add(action);
    }

    public void removeUIAction(AbstractUIAction action) {
        if (this.actions != null) {
            this.actions.remove(action);
        }
    }

    public Collection getUIActions() {
        Collection result = null;
        if (this.actions != null) {
            result = (Collection)this.actions.clone();
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("[name=\"").append(this.getName()).append("\",caption=\"").append(this.getCaption()).append("\",imageName=\"").append(this.getImageName()).append("\",imageURL=\"").append(this.getImageURL()).append("\",tinyImageName=\"").append(this.getTinyImageName()).append("\",tinyImageURL=\"").append(this.getTinyImageURL()).append("\",objectTypeName=\"").append(this.getObjectTypeName()).append("\"]");
        return result.toString();
    }

    public int hashCode() {
        int returnVal = 0;
        if (this.name != null) {
            returnVal = this.name.hashCode();
        }
        if (this.caption != null) {
            returnVal += this.caption.hashCode();
        }
        if (this.imageName != null) {
            returnVal += this.imageName.hashCode();
        }
        if (this.tinyImageName != null) {
            returnVal += this.tinyImageName.hashCode();
        }
        if (this.objectTypeName != null) {
            returnVal += this.objectTypeName.hashCode();
        }
        return returnVal;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof UIInfo) {
                UIInfo otherUIInfo = (UIInfo)obj;
                if (this.name == null ? otherUIInfo.name != null : !this.name.equals(otherUIInfo.name)) {
                    return false;
                }
                if (this.caption == null ? otherUIInfo.caption != null : !this.caption.equals(otherUIInfo.caption)) {
                    return false;
                }
                if (this.imageName == null ? otherUIInfo.imageName != null : !this.imageName.equals(otherUIInfo.imageName)) {
                    return false;
                }
                if (this.tinyImageName == null ? otherUIInfo.tinyImageName != null : !this.tinyImageName.equals(otherUIInfo.tinyImageName)) {
                    return false;
                }
                if (this.objectTypeName == null ? otherUIInfo.objectTypeName != null : !this.objectTypeName.equals(otherUIInfo.objectTypeName)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }
}

